class pantin::nsd(Boolean $external_authoritative_dns = false) {
	$fqdn = $facts['networking']['fqdn']
	$hostname = $facts['networking']['hostname']
	$domain = $facts['networking']['domain']
	$os = $facts['os']['family']

	if $os == 'OpenBSD' {
		$config_path = "/var/nsd/etc"
		$zone_base_path = "/var/nsd/zones"
		file { "$config_path/nsd.conf.d":
			ensure => directory,
		}
		exec { '/usr/sbin/nsd-control-setup':
			creates => '/var/nsd/etc/nsd_server.pem',
			before => Service['nsd'],
		}
	} else {
		$config_path = "/etc/nsd"
		$zone_base_path = "/var/lib/nsd"
		package { 'nsd':
			ensure => present,
			before => [
				Service['nsd'],
				File["$config_path/nsd.conf"],
			],
		}
		file { "$zone_base_path/master":
			ensure => directory,
		}
		file { "$zone_base_path/slave":
			owner => 'root',
			group => 'nsd',
			mode => '0775',
			ensure => directory,
		}
	}

	file { "$config_path/nsd.conf":
		mode => '0640',
		group => $os ? {
			'OpenBSD' => '_nsd',
			default => 'nsd',
		},
		content => template('pantin/var/nsd/etc/nsd.conf.erb'),
	}

	service { 'nsd':
		ensure => 'running',
		enable => true,
		subscribe => File["$config_path/nsd.conf"],
	}

	# Generate tsig with 'dd if=/dev/random bs=1 count=33 | openssl base64 -e'
	define zone($ensure = 'present',
			$primary = true,
			$signed = false,
			Sensitive $tsig = Sensitive(''),
			$peers = []) {
		$os = $facts['os']['family']
		$ipv4 = $facts['networking']['ip']
		$ipv6 = $facts['networking']['ip6']

		if $primary {
			$subpath = "master"
		} else {
			$subpath = "slave"
		}
		if $signed {
			$zone_path = "${pantin::nsd::zone_base_path}/$subpath/${name}.signed"
		} else {
			$zone_path = "${pantin::nsd::zone_base_path}/$subpath/${name}"
		}
		file { "${pantin::nsd::config_path}/nsd.conf.d/${name}.conf":
			ensure => $ensure,
			mode => '0640',
			group => $os ? {
				'OpenBSD' => '_nsd',
				default => 'nsd',
			},
			content => Sensitive(template('pantin/var/nsd/etc/nsd.conf.d.erb')),
			notify => Service['nsd'],
		}
		if $primary {
			file { "${zone_path}":
				ensure => $ensure,
				mode => '0644',
				content => $signed ? {
					true => file("pantin/var/nsd/zones/master/${name}.signed"),
					default => file("pantin/var/nsd/zones/master/$name"),
				},
				notify => Service['nsd'],
			}
		}
	}
}
