#!/usr/bin/perl
 
use strict;
use warnings;
use Crypt::OpenSSL::X509;
 
chomp(my $os = `uname -s`);
 
my $fqdn;
if ($os eq "OpenBSD") {
	chomp($fqdn = `hostname`);
} else {
	chomp($fqdn = `hostname -f`);
}
my $cert_path = '/etc/ssl/uacme/' . $fqdn . '/cert.pem';

# Read the certificate
my $x509;
eval {
	$x509 = Crypt::OpenSSL::X509->new_from_file($cert_path);
} or die("$cert_path: $!");

my $names = $x509->subjectaltname();
print('{ "subject_alt_names": [');
my $first = 1;
foreach my $name (@$names) {
	if (defined($name->{'dNSName'})) {
		if ($first eq 1) {
			$first = 0;
		} else {
			print(', ');
		}
		print('"' . $name->{'dNSName'} . '"');
	}
}
print("] }\n");
 
exit(0);
