class pantin::pf(
	String $ruleset = 'cloud',
	Boolean $external_authoritative_dns = false,
) {
	file { '/etc/pf.conf':
		mode => '0600',
		content => template("pantin/etc/pf.conf.$ruleset.erb"),
	}

	service { 'pf':
		enable => true,
		ensure => 'running',
		status => 'pfctl -si | grep -q "^Status: Enabled"',
		restart => 'pfctl -f /etc/pf.conf',
		subscribe => File['/etc/pf.conf'],
	}
}
