class pantin::root(Boolean $manage_password = false) {
	if $manage_password {
		user { 'root':
			password => lookup('pantin::root::password'),
		}
	}

	file { '/root/.ssh':
		mode => '0700',
		ensure => directory,
	}
	file { '/root/.ssh/authorized_keys':
		mode => '0600',
		content => file('pantin/root/ssh/authorized_keys'),
	}
	file { '/root/.bash_profile':
		mode => '0755',
		content => "#!/bin/bash\n\nexport TMOUT=120\nexport PS1='# '\n",
	}
}
