class pantin::letsencrypt(Array[String] $subject_alt_names = []) {
	$fqdn = $facts['networking']['fqdn']
	$sans = join($subject_alt_names, ' ')
	$hour = fqdn_rand(24)
	$minute = fqdn_rand(60)

	group { 'ualpn':
		system => true,
	} ->
	user { 'ualpn':
		gid => 'ualpn',
		system => true,
	} ->
	package { 'uacme':
		ensure => present,
	} ->
	file { "/etc/init.d/ualpn":
		mode => '0755',
		content => file('pantin/etc/init.d/ualpn'),
	} ->
	exec { 'uacme-new-key':
		command => 'uacme -y -c /etc/ssl/uacme new',
		creates => '/etc/ssl/uacme/private/key.pem',
	}

	service { 'ualpn':
		ensure => 'running',
		enable => true,
		subscribe => File['/etc/init.d/ualpn'],
	}

	exec { 'uacme-issue-cert':
		command => "uacme -c /etc/ssl/uacme -h /usr/share/uacme/ualpn.sh issue $fqdn $sans",
		creates => "/etc/ssl/uacme/$fqdn/cert.pem",
		require => Service['ualpn'],
	} ->
	file { "/etc/cron.d/uacme-issue":
		mode => '0644',
		content => "$minute $hour * * * /usr/bin/uacme -c /etc/ssl/uacme -h /usr/share/uacme/ualpn.sh issue $fqdn $sans\n",
	} ->
	file { "/etc/ssl/private/$fqdn.pem":
		mode => '0600',
		source => "/etc/ssl/uacme/private/$fqdn/key.pem",
	} ->
	file { "/etc/ssl/certs/$fqdn.pem":
		source => "/etc/ssl/uacme/$fqdn/cert.pem",
	}
}
