class pantin::unbound {
	$os = $facts['os']['family']
	$domain = $facts['networking']['domain']

	if $os == 'OpenBSD' {
		$cfgbase = '/var/unbound/etc'
		$rootkey = '/var/unbound/db/root.key'
	} else {
		$cfgbase = '/etc/unbound'
		$rootkey = '/var/lib/unbound/root.key'
		package { ['unbound', 'unbound-anchor']:
			ensure => present,
			before => File["$cfgbase/unbound.conf.d/forward.conf"],
		}
	}

	file { "$cfgbase/unbound.conf.d/forward.conf":
		mode => '0644',
		content => template('pantin/etc/unbound/unbound.conf.d/forward.conf.erb'),
	} ->
	exec { 'unbound-anchor':
		command => "unbound-anchor -a $rootkey",
		creates => "$rootkey",
	} ->
	service { 'unbound':
		ensure => running,
		enable => true,
		subscribe => File["$cfgbase/unbound.conf.d/forward.conf"]
	}
	if 'dhcp' in $facts['networking'] {
		file { '/etc/resolv.conf':
			mode => '0644',
			content => inline_template("domain <%= @domain %>\nsearch <%= @domain %>\nnameserver 127.0.0.1\n"),
			require => Service['unbound'],
		}
	}
}
