class overnet::sudo(Array[String] $admins = []) {
	package { 'sudo':
		ensure => present,
	}

	$admins.each |String $admin| {
		augeas { "sudo-membership-${admin}":
			context => "/files/etc/group/sudo",
			changes => [
				# Set the value to $member at index where $member
				# is (therefore not adding dupes)
				"set user[.='$admin'] $admin",
			],
		}
	}
}
