class pantin::postgres {
	package { 'postgresql':
		ensure => present,
	} ->
	file { '/var/lib/postgresql/dump':
		mode => '0700',
		owner => 'postgres',
		group => 'postgres',
		ensure => directory,
	} ->
	file { '/etc/cron.d/pgdump':
		owner => 'root',
		group => 'root',
		mode => '0644',
		content => "10 1 * * * postgres /usr/bin/pg_dumpall | gzip -c > /var/lib/postgresql/dump/sql.gz\n",
	}
}
