class pantin::apache_http_server {
	$fqdn = $facts['networking']['fqdn']
	$hostname = $facts['networking']['hostname']
	$domain = $facts['networking']['domain']
	define www($ensure = 'present') {
		$fqdn = $facts['networking']['fqdn']
		$hostname = $facts['networking']['hostname']
		$domain = $facts['networking']['domain']
		if $ensure == 'present' {
			exec { "site-${name}-enable":
				command => "a2ensite $name",
				creates => "/etc/apache2/sites-enabled/${name}.conf",
				notify => Service['apache2'],
				require => File["/etc/apache2/sites-available/${name}.conf"],
			}
			file { "/etc/apache2/sites-available/${name}.conf":
				ensure => $ensure,
				mode => '0644',
				content => template("pantin/etc/apache2/sites-available/${name}.conf.erb"),
				before => Service['apache2'],
			}
		} else {
			exec { "site-${name}-disable":
				command => "a2dissite $name",
				refreshonly => true,
				notify => Service['apache2'],
			}
			file { "/etc/apache2/sites-available/${name}.conf":
				ensure => $ensure,
				before => Service['apache2'],
			}
		}

		file { "/var/log/apache2/${name}":
			mode => '0755',
			owner => 'root',
			group => 'adm',
			ensure => directory,
			before => Service['apache2'],
		}
	}

	define mod($ensure = 'present', $has_conf = false) {
		if $ensure == 'present' {
			exec { "mod-${name}-enable":
				command => "a2enmod $name",
				creates => "/etc/apache2/mods-enabled/${name}.load",
				notify => Service['apache2'],
			}
		} else {
			exec { "mod-${name}-disable":
				command => "a2dismod $name",
				refreshonly => true,
				notify => Service['apache2'],
			}
		}

		if $has_conf {
			file { "/etc/apache2/modules-available/${name}.conf":
				ensure => $ensure,
				mode => '0644',
				notify => Service['apache2'],
				content => template("pantin/etc/apache2/mods-available/${name}.conf.erb"),
			}
		}
	}

	package { ['apache2', 'libapache2-mod-php']:
		ensure => present,
	}

	exec { 'conf-javascript-enable':
		command => 'a2enconf javascript-common',
		creates => '/etc/apache2/conf-enabled/javascript-common.conf',
		notify => Service['apache2'],
	}

	file { '/var/www/html/index.html':
		ensure => absent,
	} ->
	service { 'apache2':
		ensure => 'running',
		enable => true,
		subscribe => [
			File["/etc/ssl/certs/$hostname-crt.pem"],
			File["/etc/ssl/private/$hostname-key.pem"],
		]
	}

	pantin::apache_http_server::www { '000-default':
		ensure => absent,
	}
	pantin::apache_http_server::www { 'minmaxiste':
		ensure => present,
	}

	pantin::apache_http_server::mod { [
		'ssl',
		'dav',
		'dav_fs',
		'ext_filter',
		'proxy',
		'proxy_http',
		'rewrite',
		'headers' ]:
		ensure => present,
	}

	file { '/var/www/html':
		mode => '0755',
		ensure => directory,
	}
	file { '/var/www/html/.well-known':
		mode => '0755',
		ensure => directory,
	}
	file { '/var/www/html/__special':
		ensure => absent,
	}
	file { '/var/www/html/md.css':
		mode => '0644',
		content => file('pantin/var/www/html/md.css'),
	}
	file { '/var/www/html/robots.txt':
		mode => '0644',
		content => file('pantin/var/www/html/robots.txt'),
	}
	file { '/var/www/md-to-html-template.html':
		mode => '0644',
		content => file('pantin/var/www/md-to-html-template.html'),
	}
}
