class pantin::plalonde {
	$os = $facts['os']['family']

	group { 'plalonde':
		gid => 5000,
		forcelocal => true,
	} ->
	user { 'plalonde':
		uid => 5000,
		gid => 5000,
		forcelocal => true,
		managehome => true,
		home => '/home/plalonde',
		groups => $os ? {
			'OpenBSD' => [],
			default => [
				'adm',
				'dialout',
				'cdrom',
				'floppy',
				'dip',
				'plugdev',
				'staff',
			],
		},
		shell => $os ? {
			'OpenBSD' => '/bin/sh',
			default => '/bin/bash',
		},
		password => $os ? {
			'OpenBSD' => lookup('pantin::plalonde::password'),
			default => undef,
		},
	} ->
	file { '/home/plalonde':
		owner => 'plalonde',
		group => 'plalonde',
		mode => '0700',
		ensure => directory,
	}
	file { '/home/plalonde/.ssh':
		mode => '0700',
		owner => 'plalonde',
		group => 'plalonde',
		ensure => directory,
	}
	file { '/home/plalonde/.ssh/authorized_keys':
		mode => '0600',
		owner => 'plalonde',
		group => 'plalonde',
		content => file('pantin/root/ssh/authorized_keys'),
	}
}
