class pantin::iptables(String $ruleset = undef) {
	$ipv4 = $facts['networking']['ip']
	$ipv6 = $facts['networking']['ip6']
	package { 'iptables-persistent':
		ensure => present,
	} ->
	file { '/etc/iptables/rules.v4':
		mode => '0644',
		content => template("pantin/etc/iptables/${ruleset}.v4.erb"),
	} ->
	file { '/etc/iptables/rules.v6':
		mode => '0644',
		content => template("pantin/etc/iptables/${ruleset}.v6.erb"),
	} ->
	service { 'netfilter-persistent':
		ensure => running,
		enable => true,
		subscribe => File[
			'/etc/iptables/rules.v4',
			'/etc/iptables/rules.v6',
		],
	}
}
