class pantin::apt {
	define source($ensure = 'present', $keyring = '') {
		$srcfile = "/etc/apt/sources.list.d/${name}.sources"
		if $keyring != '' {
			file { $keyring:
				ensure => $ensure,
				mode => '0644',
				content => file("pantin${keyring}"),
				before => File[$srcfile],
				notify => Exec['apt-update'],
			}
		}
		file { "$srcfile":
			ensure => $ensure,
			mode => '0644',
			content => template("pantin/etc/apt/sources.list.d/${name}.sources.erb"),
			notify => Exec['apt-update'],
		}
	}

	file { '/etc/apt/apt.conf.d/99norecommends':
		mode => '0644',
		content => file('pantin/etc/apt/apt.conf.d/99norecommends'),
	}
	file { '/etc/apt/sources.list':
		ensure => absent,
	}
	file { '/etc/apt/sources.list.d/devuan.sources':
		mode => '0644',
		content => template('pantin/etc/apt/sources.list.d/devuan.sources.erb'),
	}

	exec { 'apt-update':
		command => 'apt-get update && apt autoremove',
		refreshonly => true,
		subscribe => [
			File['/etc/apt/apt.conf.d/99norecommends'],
			File['/etc/apt/sources.list'],
			File['/etc/apt/sources.list.d/devuan.sources'],
		]
	} -> Package <| |>
}
