class pantin::sysctl {
	exec { 'reload-sysctl':
		command => $facts['os']['family'] ? {
			'OpenBSD' => 'sysctl -f /etc/sysctl.conf',
			default => 'sysctl -p',
		},
		refreshonly => true,
	}

	file { '/etc/sysctl.conf':
		mode => '0644',
		ensure => present,
	}

	define value(
		$ensure = 'present',
		$value,
	) {
		augeas { "sysctl-$name":
			context => '/files/etc/sysctl.conf',
			changes => [
				"set $name $value",
			],
			notify => Exec['reload-sysctl'],
		}
	}

	if $facts['kernel'] == 'Linux' {
		# We are running user-facing services on the cloud in most
		# cases, therefore we should always avoid swapping
		pantin::sysctl::value { 'vm.swappiness':
			value => '0',
		}
	}
}
