class pantin::www_minmaxiste_com(
	$ensure = 'present',
) {
	file { '/var/www/minmaxiste':
		ensure => directory,
	} ->
	pantin::apache_http_server::www{ 'minmaxiste.com':
		ensure => $ensure,
		aliases => [ 'www.minmaxiste.com' ],
		docroot => '/var/www/minmaxiste/html',
		docroot_options => [ 'MultiViews', 'FollowSymlinks' ],
	}
	pantin::apache_http_server::www{ 'apt.minmaxiste.com':
		ensure => $ensure,
		template => 'apt',
		docroot => '/var/www/apt',
	}
	pantin::apache_http_server::www{ 'openbsd-repo.minmaxiste.com':
		ensure => absent,
		docroot => '/var/www/openbsd-repo',
		docroot_options => [ 'Indexes' ],
	}
	pantin::apache_http_server::www{ 'repo-openbsd.minmaxiste.com':
		ensure => $ensure,
		docroot => '/var/www/repo-openbsd',
		docroot_options => [ 'Indexes' ],
	}
}
