class pantin::sshd {
	$os = $facts['os']['family']

	if $os == 'OpenBSD' {
		$svc = 'sshd'
	} else {
		$svc = 'ssh'
		package { 'openssh-server':
			ensure => present,
		}
	}

	service { $svc:
		ensure => 'running',
		enable => true,
	}

	file { '/etc/ssh/sshd_config':
		mode => '0644',
		content => template('pantin/etc/ssh/sshd_config.erb'),
		notify => Service[$svc],
	}
}
