class pantin::letsencrypt {
	$hostname = $facts['networking']['hostname']
	$certfilename = lookup('pantin::letsencrypt::certname', undef, undef, "$hostname-crt.pem")
	file { "/etc/ssl/private/$hostname-key.pem":
		mode => '0600',
		content => lookup('pantin::letsencrypt::key'),
	} ->
	file { "/etc/ssl/certs/$hostname-crt.pem":
		mode => '0644',
		content => file("pantin/etc/ssl/certs/$certfilename"),
	}
}
