class pantin::apt {
	Package {
		# TODO: I don't think require => Exec[] works well to pause
		# while apt-update finishes
		require => Exec['apt-update'],
	}

	define source($ensure = 'present', $keyring = '') {
		$srcfile = "/etc/apt/sources.list.d/${name}.sources"
		if $keyring != '' {
			file { $keyring:
				ensure => $ensure,
				mode => '0644',
				content => file("pantin${keyring}"),
				before => File[$srcfile],
				notify => Exec['apt-update'],
			}
		}
		file { "$srcfile":
			ensure => $ensure,
			mode => '0644',
			content => template("pantin/etc/apt/sources.list.d/${name}.sources.erb"),
		}
	}

	file { '/etc/apt/apt.conf.d/99norecommends':
		mode => '0644',
		content => file('pantin/etc/apt/apt.conf.d/99norecommends'),
	}
	file { '/etc/apt/sources.list':
		ensure => absent,
	} ->
	file { '/etc/apt/sources.list.d/devuan.sources':
		mode => '0644',
		content => template('pantin/etc/apt/sources.list.d/devuan.sources.erb'),
	}

	exec { 'apt-update':
		command => 'apt-get update',
		refreshonly => true,
		subscribe => [
			File['/etc/apt/apt.conf.d/99norecommends'],
			File['/etc/apt/sources.list.d/devuan.sources'],
		]
	}
}
