class pantin {
	$os = $facts['os']['family']
	$rootgrp = $os ? {
		'OpenBSD' => 'wheel',
		default => 'root',
	}

	File {
		owner => 'root',
		group => $rootgrp,
	}
	Exec {
		path => [
			'/bin',
			'/sbin',
			'/usr/bin',
			'/usr/sbin',
			'/usr/local/bin',
			'/usr/local/sbin',
		],
	}

	# Bootstrap Puppet and packaging
	case $os {
		'OpenBSD': {
			file { '/etc/crontab':
				owner => 'root',
				group => 'wheel',
				mode => '0600',
				content => file('pantin/etc/crontab'),
			}
			exec { 'refresh-crontab':
				command => 'crontab -u root /etc/crontab',
				refreshonly => true,
				subscribe => File["/etc/crontab"],
			}

			package { 'puppet%8':
				ensure => present,
			}
			package { 'augeas':
				ensure => present,
			}
			file { '/etc/puppetlabs/code/hieradata':
				owner => 'root',
				group => 'wheel',
				mode => '0700',
				ensure => directory,
			}
		}
		default: {
			file { '/etc/puppet/data':
				owner => 'root',
				group => 'root',
				mode => '0700',
				ensure => directory,
			}
			include pantin::apt
			pantin::apt::source { 'pantin':
				keyring => '/etc/apt/trusted.gpg.d/plalonde.gpg',
			}
			file { '/etc/cron.d/pantin-manifests':
				owner => 'root',
				group => 'root',
				mode => '0644',
				content => file('pantin/etc/cron.d/pantin-manifests'),
			}
		}
	}

	$util_pkgs = $os ? {
		'OpenBSD' => [
			'curl',
			'git',
			'rsync',
		],
		default => [
			'anyvault',
			'athena-jot',
			'bc',
			'cryptsetup',
			'curl',
			'ethtool',
			'fuse3',
			'git',
			'bind9-dnsutils',
			'fio',
			'jq',
			'gnupg',
			'ldnsutils',
			'linux-image-amd64',
			'linux-headers-amd64',
			'lsof',
			'lvm2',
			'ncal',
			'net-tools',
			'netcat-openbsd',
			'nmap',
			'openssl',
			'pandoc',
			'p0f',
			'rclone',
			'rsync',
			'rtorrent',
			'strace',
			'socat',
			'sysstat',
			'tcpdump',
			'vim',
			'wget',
			'whois',
		],
	}

	package { $util_pkgs:
		ensure => present,
	}

	# Vim
	file { 'system-vimrc':
		path => $os ? {
			'OpenBSD' => '/usr/local/share/vim/vimrc',
			default => '/etc/vim/vimrc.local'
		},
		mode => '0644',
		content => template('pantin/etc/vim/vimrc.local.erb'),
	}

	# OS-specific stuff
	if $os == 'Debian' {
		file { '/etc/vim/vimrc':
			mode => '0644',
			content => file('pantin/etc/vim/vimrc'),
		}
		include pantin::syslog
	}
	if $os == 'OpenBSD' {
		package { 'vim':
			flavor => 'no_x11',
			ensure => present,
		}
		if $facts['infra']['provider'] == "ovh" {
			# OVH doesn't need serial console redirection
			file { '/etc/boot.conf':
				ensure => absent,
			}
		}
		service { 'sndiod':
			enable => false,
			ensure => 'stopped',
		}
	}

	# Standard directories
	file { '/var/backups-staging':
		mode => '0755',
		ensure => directory,
	}

	notice(join(["infra.provider: ", $facts['infra']['provider']]))
	notice(join(["infra.geo: ", $facts['infra']['geo']]))
	notice(join(["infra.baremetal: ", $facts['infra']['baremetal']]))
	notice(join(["infra.api: ", $facts['infra']['api']]))

	include pantin::root
	include pantin::unattended_upgrades
	include pantin::ntp
	include pantin::sshd

	lookup('classes').include
}
